% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ino.R
\name{setup_ino}
\alias{setup_ino}
\title{Setup}
\format{
The format of an \code{ino} object is documented in \code{\link{new_ino}}.
}
\usage{
setup_ino(
  f,
  npar,
  global = NULL,
  ...,
  mpvs = character(),
  opt = set_optimizer_nlm(),
  test_par = list(validate = TRUE, init_rest = list(lower = -1, upper = 1), init_digits =
    2, f_checks = 10, f_checks_time = 1),
  verbose = getOption("ino_progress")
)
}
\arguments{
\item{f}{An object of class \code{function}, the function to be optimized.}

\item{npar}{The length of the first argument of \code{f}, i.e. the argument over which
\code{f} is optimized.}

\item{global}{Either \code{NULL} (default) or the point where \code{f} obtains its global
optimum (i.e., a numeric vector of length \code{npar}).}

\item{...}{Additional and named arguments to be passed to \code{f} (optional).}

\item{mpvs}{A character vector of the argument names with multiple parameter values.
None per default.}

\item{opt}{The output of \code{\link{set_optimizer}}, which is an object of class
\code{optimizer}.
Per default, \code{opt = set_optimizer_nlm()}, which specifies the
\code{\link[stats]{nlm}} optimizer.
Can also be a (named) list of multiple \code{optimizer} objects.}

\item{test_par}{A list of test parameters for an \code{ino} object:
\itemize{
\item \code{validate}, a Boolean, set to \code{TRUE} (\code{FALSE}) to (not)
validate the \code{ino} object. Per default, \code{validate = TRUE}.
\item \code{init_rest}, a list of two elements, \code{lower} and \code{upper},
with lower and upper limits, respectively, for test values for \code{f}.
Can be single values (for joint limits) or numeric vectors of length
\code{npar} (for individual limits).
Per default, \code{lower = -1} and \code{upper = 1}.
\item \code{init_digits}, the number of decimal places for the test initial
values. Per default, \code{init_digits = 2}.
\item \code{f_checks}, the number of checks for \code{f} with random input values
(that fulfill the \code{init_rest} restrictions).
Per default, \code{f_checks = 10}.
\item \code{f_check_time}, the maximum number of seconds for a single check for
\code{f}.
A check is considered to be successful, if no error occurred
within \code{f_check_time} seconds.
Per default, \code{f_check_time = 1}.
}}

\item{verbose}{A boolean, which indicates whether progress should be printed.
Set to \code{TRUE} (\code{FALSE}) to print (hide) progress.
The default is \code{getOption("ino_progress")}, which is set to \code{TRUE}
when the package is loaded.}
}
\value{
An object of class \code{ino}.
}
\description{
Use this function to specify the numerical optimization problem. The function
returns an object of class \code{ino} that contains all specifications.
}
\details{
\subsection{Specifying a function}{

One real-valued function \code{f} must be specified per \code{ino} object.
The function is optimized over its first argument, the target argument, which
must be a numeric vector of length \code{npar}, followed by any other
arguments specified via the \code{...} argument.
}

\subsection{Specifying multiple parameter values}{

You can specify multiple values for each \code{...} parameter for comparison.
Such arguments must be in \code{list} format, where each list element must be
a valid parameter value. The list elements can be named.
The names of the \code{...} parameters with multiple values must be added to
the \code{mpvs} input.
}

\subsection{Specifying an optimizer}{

The numerical optimizer must be specified via the \code{opt} argument as an
\code{optimizer} object.
Such \code{optimizer} objects can be created via the function
\code{\link[optimizeR]{set_optimizer}}.
You can specify multiple \code{optimizer} objects for comparison by passing
a (named) list of optimizers to \code{opt}.
}

\subsection{An example}{

Let \code{nll} be a negative log-likelihood function.
Its first argument is a numeric vector of length \code{2}.
The global optimum is obtained in the origin.
The function has the additional argument \code{data}.
Say that you want to conduct an experiment of the initialization effect for
\code{nll} for two different data sets.
And say that you want to compare the \code{\link[stats]{nlm}} and the
\code{\link[stats]{optim}} optimizer.
Then, specify
\preformatted{
setup_ino(
  f = nll,
  npar = 2,
  global = c(0,0),
  data = list("data1" = <data set 1>,
              "data2" = <data set 2>),
  mpvs = "data",
  opt = list("nlm"   = set_optimizer_nlm(),
             "optim" = set_optimizer_optim())
)
}
}
}
\examples{
setup_ino(
  f = f_ll_hmm,
  npar = 4,
  data = earthquakes,
  N = 2,
  neg = TRUE
)

}
\seealso{
\code{\link[=set_optimizer]{set_optimizer()}} to specify an optimizer.
}
\keyword{specification}
