% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sim_mnp}
\alias{sim_mnp}
\title{Simulate data from a (normally mixed) multinomial probit model}
\usage{
sim_mnp(
  N,
  T = 1,
  J,
  P,
  b = stats::rnorm(P),
  Omega = NULL,
  Sigma = diag(J),
  X = function() matrix(stats::rnorm(J * P), nrow = J, ncol = P)
)
}
\arguments{
\item{N}{The number of observations.}

\item{T}{The number of choice occasions with \code{T = 1} per default.}

\item{J}{The number of alternatives.}

\item{P}{The number of choice covariates.}

\item{b}{The mean effects vector of length \code{P}, first element must be \code{1}.}

\item{Omega}{The covariance matrix of the normal mixing distribution of dimension \code{P}
times \code{P}. Set to \code{NULL} (the default) for no mixing distribution.}

\item{Sigma}{The error term covariance matrix of dimension \code{J} times \code{J}.}

\item{X}{A function that samples the covariates. It must return a numeric matrix
of dimension \code{J} times \code{P}.}
}
\value{
A \code{data.frame}. The first column (\code{N}) is the identifier for the
decider, the next column (\code{T}) the identifier for the choice occasion.
Next comes the column \code{y} with the indices of the chosen alternatives.
The last columns contain the column-wise entries of the covariate matrices.

The true model coefficients are added to the output via the attribute
\code{"true"}. They are already normalized and can be directly compared with
the maximum likelihood estimate.

Additional attributes are \code{"J"} (the number of alternatives),
\code{"P"} (the number of choice covariates), and \code{"mix"} (a boolean
which is \code{TRUE} if \code{Omega} is not \code{NULL}).
}
\description{
Simulate data from a (normally mixed) multinomial probit model
}
\examples{
sim_mnp(N = 3, J = 2, P = 2, b = c(1,-1), Omega = diag(2), Sigma = diag(2))

}
\seealso{
\code{\link[=f_ll_mnp]{f_ll_mnp()}} for computing the log-likelihood of a (normally mixed)
multinomial probit model.
}
\keyword{function}
\keyword{internal}
