% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sim_mnp}
\alias{sim_mnp}
\title{Simulate data from a (normally mixed) multinomial probit model}
\usage{
sim_mnp(
  N,
  Tp = 1,
  J,
  P,
  b = stats::rnorm(P),
  Omega = NULL,
  Sigma = diag(J),
  X = function(n, t) matrix(stats::rnorm(J * P), nrow = J, ncol = P),
  seed = NULL
)
}
\arguments{
\item{N}{An \code{integer}, the number of observations.}

\item{Tp}{An \code{integer}, the number of choice occasions.
By default, \code{Tp = 1}.}

\item{J}{An \code{integer}, the number of alternatives.
Must be greater of equal \code{2}.}

\item{P}{An \code{integer}, the number of choice covariates.}

\item{b}{A \code{numeric} vector, the mean effects vector of length \code{P}.
The first element must be \code{1} (for normalization).}

\item{Omega}{A \code{matrix}, the covariance matrix of the normal mixing distribution of
dimension \code{P} times \code{P}.
Set to \code{NULL} (the default) for no mixing distribution.}

\item{Sigma}{A \code{matrix}, the error term covariance matrix of dimension \code{J}
times \code{J}.}

\item{X}{A \code{function} that samples the covariates of decider \code{n} at choice
occasion \code{t}. It must
\itemize{
\item have two arguments \code{n} and \code{t},
\item return a \code{numeric} \code{matrix} of dimension \code{J} times \code{P}.
}}

\item{seed}{Optionally set a seed for the choice data simulation.}
}
\value{
A \code{data.frame}. The first column (\code{n}) is the identifier for the
decider, the next column (\code{t}) the identifier for the choice occasion.
Next comes the column \code{y} with the indices of the chosen alternatives.
The last columns contain the column-wise entries of the covariate matrices.

The true model coefficients are added to the output via the attribute
\code{"true"}. They are already normalized and can be directly compared with
the maximum likelihood estimate.

Additional attributes are \code{"J"} (the number of alternatives),
\code{"P"} (the number of choice covariates), and \code{"mix"} (a boolean
which is \code{TRUE} if \code{Omega} is not \code{NULL}).
}
\description{
Simulate data from a (normally mixed) multinomial probit model
}
\examples{
sim_mnp(N = 3, J = 3, P = 2, b = c(1, -1), Omega = diag(2), Sigma = diag(3))

}
\seealso{
\code{\link[=f_ll_mnp]{f_ll_mnp()}} for computing the log-likelihood of a (normally mixed)
multinomial probit model.
}
\keyword{function}
