% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_cluster.R
\name{doKmeansClust}
\alias{doKmeansClust}
\title{Performs a k-means cluster analysis on the basis of the word-occurrence data.frame.}
\usage{
doKmeansClust(wordF, nbClust = 4, nbIter = 10, algo = "Hartigan-Wong",
  getPlot = TRUE, mwidth = 800, mheight = 800, formatType = "png", ...)
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{nbClust}{The number of clusters.}

\item{nbIter}{The number of iterations allowed.}

\item{algo}{The algoritm used (see \code{\link[stats]{kmeans}}).}

\item{getPlot}{If \code{TRUE}, save the k-means cluster plot in the RESULTS directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}

\item{...}{Additional arguments from the \code{\link[stats]{kmeans}} function.}
}
\value{
An object of class kmeans (see \code{\link[stats]{kmeans}}).
}
\description{
Performs a k-means cluster analysis on the basis of the word-occurrence data.frame
  using \code{\link[stats]{kmeans}} function.
}
\examples{
data("loremIpsum")
loremIpsum01 <- loremIpsum[1:100]
loremIpsum02 <- loremIpsum[101:200]
loremIpsum03 <- loremIpsum[201:300]
loremIpsum04 <- loremIpsum[301:400]
loremIpsum05 <- loremIpsum[401:500]
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum01, file = "RESULTS/loremIpsum01.txt")
write(x = loremIpsum02, file = "RESULTS/loremIpsum02.txt")
write(x = loremIpsum03, file = "RESULTS/loremIpsum03.txt")
write(x = loremIpsum04, file = "RESULTS/loremIpsum04.txt")
write(x = loremIpsum05, file = "RESULTS/loremIpsum05.txt")
wordOccuDF <- getwordOccuDF(mywd = paste0(getwd(), "/RESULTS"), excludeSW = FALSE)
file.remove(list.files(full.names = TRUE, 
  path = paste0(getwd(), "/RESULTS"), pattern = "loremIpsum"))
doKmeansClust(wordF = wordOccuDF, nbClust = 2)
}
