% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon.R
\name{download_taxon}
\alias{download_taxon}
\title{Download NCBI taxonomy database.}
\usage{
download_taxon(synonyms = FALSE, quiet = FALSE)
}
\arguments{
\item{synonyms}{logical indicating whether synonyms should be included.
Note that this increases the size of the returned object by around 10\%.}

\item{quiet}{logical indicating whether progress should be printed to the console.}
}
\value{
a dataframe with the following elements:
  "tax_id", "parent_tax_id", "rank", "name".
}
\description{
This function accesses the NCBI API and gets an up-to-date copy of the taxonomy
  database.
}
\details{
This function downloads the NCBI taxon database as a data.frame
  object with the following columns:
  "tax_id", "parent_tax_id", "rank", "name".
  As of early 2018 the zip archive to download is approximately
  40Mb in size, and the output dataframe object is around
  200Mb in memory. Once downloaded, the dataframe can be pruned
  for increased speed and memory efficiency using the function
  \code{\link{prune_taxon}}.
}
\examples{
\donttest{
  taxonomy <- download_taxon()
}
}
\references{
Federhen S (2012) The NCBI Taxonomy database.
 \emph{Nucleic Acids Research}
 \strong{40}, D136-D143. doi:10.1093/nar/gkr1178.

 \url{https://www.ncbi.nlm.nih.gov/taxonomy/}
}
\author{
Shaun Wilkinson
}
