% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon.R
\name{get_taxID}
\alias{get_taxID}
\title{Derive taxon ID from a lineage string or species name.}
\usage{
get_taxID(lineage, db, multimatch = "NA")
}
\arguments{
\item{lineage}{A semicolon-delimited lineage string or lineage name.}

\item{db}{the NCBI taxon database (as a data.frame object).
See download_taxon for details.}

\item{multimatch}{character, the value to return if the query matches multiple
entries in the database. Accepted values are "NA" (default), and "first"
(the first match).}
}
\value{
The unique taxon database ID (integer).
}
\description{
This function returns the unique taxon ID associated with a given
  semicolon-delimited lineage string or taxon,
  by looking up the NCBI taxon database.
}
\details{
This function will return NA if the lineage is not found in the
  database or it matches multiple entries.
}
\examples{
data(whales)
data(whale_taxa)
get_taxID(attr(whales, "lineage")[1], db = whale_taxa)
}
\references{
Federhen S (2012) The NCBI Taxonomy database.
 \emph{Nucleic Acids Research}
 \strong{40}, D136-D143. doi:10.1093/nar/gkr1178.

 \url{https://www.ncbi.nlm.nih.gov/taxonomy/}
}
\author{
Shaun Wilkinson
}
