% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_insee.R
\name{search_insee}
\alias{search_insee}
\title{Search a pattern among insee dataset names}
\usage{
search_insee(pattern)
}
\arguments{
\item{pattern}{string used to filtern the dataset list}
}
\value{
the dataset list table filtered with the pattern
}
\description{
Search a pattern among insee dataset names
}
\details{
the function ignores accents and cases
}
\examples{
\donttest{
# example 1 : search one pattern, the accents do not matter
writeLines("the word 'enqu\U00EAte' (meaning survey in French) will match with 'enquete'")
dataset_enquete = search_insee("enquete")

# example 2 : search multiple patterns
dataset_survey_gdp = search_insee("Survey|gdp")
}
}
