% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_deviance.R
\name{get_deviance}
\alias{get_deviance}
\alias{get_deviance.default}
\title{Model Deviance}
\usage{
get_deviance(x, ...)

\method{get_deviance}{default}(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{A model.}

\item{...}{Not used.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
The model deviance.
}
\description{
Returns model deviance (see \code{stats::deviance()}).
}
\details{
For GLMMs of class \code{glmerMod}, \code{glmmTMB} or \code{MixMod},
the \emph{absolute unconditional} deviance is returned (see 'Details' in
\code{?lme4::`merMod-class`}), i.e. minus twice the log-likelihood. To get
the \emph{relative conditional} deviance (relative to a saturated model,
conditioned on the conditional modes of random effects), use \code{deviance()}.
The value returned \code{get_deviance()} usually equals the deviance-value
from the \code{summary()}.
}
\examples{
data(mtcars)
x <- lm(mpg ~ cyl, data = mtcars)
get_deviance(x)
}
