% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_variables.R
\name{find_variables}
\alias{find_variables}
\title{Find names of all variables}
\usage{
find_variables(
  x,
  effects = "all",
  component = "all",
  flatten = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A fitted model.}

\item{effects}{Should variables for fixed effects, random effects
or both be returned? Only applies to mixed models. May be abbreviated.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned
as character vector, not as list. Duplicated values are removed.}

\item{verbose}{Toggle warnings.}
}
\value{
A list with (depending on the model) following elements (character
vectors):
\itemize{
\item \code{response}, the name of the response variable
\item \code{conditional}, the names of the predictor variables from the \emph{conditional} model (as opposed to the zero-inflated part of a model)
\item \code{cluster}, the names of cluster or grouping variables
\item \code{dispersion}, the name of the dispersion terms
\item \code{instruments}, the names of instrumental variables
\item \code{random}, the names of the random effects (grouping factors)
\item \code{zero_inflated}, the names of the predictor variables from the \emph{zero-inflated} part of the model
\item \code{zero_inflated_random}, the names of the random effects (grouping factors)
}
}
\description{
Returns a list with the names of all variables, including
response value and random effects.
}
\note{
The difference to \code{\link[=find_terms]{find_terms()}} is that
\code{find_variables()} returns each variable name only once, while
\code{find_terms()} may return a variable multiple times in case of
transformations or when arithmetic expressions were used in the formula.
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}
}

\examples{
\dontshow{if (require("lme4", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(cbpp, package = "lme4")
data(sleepstudy, package = "lme4")
# some data preparation...
cbpp$trials <- cbpp$size - cbpp$incidence
sleepstudy$mygrp <- sample(1:5, size = 180, replace = TRUE)
sleepstudy$mysubgrp <- NA
for (i in 1:5) {
  filter_group <- sleepstudy$mygrp == i
  sleepstudy$mysubgrp[filter_group] <-
    sample(1:30, size = sum(filter_group), replace = TRUE)
}

m1 <- lme4::glmer(
  cbind(incidence, size - incidence) ~ period + (1 | herd),
  data = cbpp,
  family = binomial
)
find_variables(m1)

m2 <- lme4::lmer(
  Reaction ~ Days + (1 | mygrp / mysubgrp) + (1 | Subject),
  data = sleepstudy
)
find_variables(m2)
find_variables(m2, flatten = TRUE)
\dontshow{\}) # examplesIf}
}
