% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_model.R
\name{is_model}
\alias{is_model}
\title{Checks if an object is a (supported) regression model object}
\usage{
is_model(x)
}
\arguments{
\item{x}{An object.}
}
\value{
A logical, \code{TRUE} if \code{x} is a (supported) model object.
}
\description{
Small helper that checks if a model is a \emph{supported}
 (regression) model object.
}
\details{
This function returns \code{TRUE} is \code{x} is a model object
  that works with the package's functions. A list of supported models can
  also be found here: \url{https://github.com/easystats/insight}.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)

is_model(m)
is_model(mtcars)

}
