% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_table.R
\name{format_table}
\alias{format_table}
\title{Parameter table formatting}
\usage{
format_table(
  x,
  pretty_names = TRUE,
  stars = FALSE,
  digits = 2,
  ci_width = "auto",
  ci_brackets = TRUE,
  ci_digits = 2,
  p_digits = 3,
  rope_digits = 2,
  ic_digits = 1,
  zap_small = FALSE,
  preserve_attributes = FALSE,
  exact = TRUE,
  use_symbols = getOption("insight_use_symbols", FALSE),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A data frame of model's parameters, as returned by various functions
of the \strong{easystats}-packages. May also be a result from
\code{broom::tidy()}.}

\item{pretty_names}{Return "pretty" (i.e. more human readable) parameter
names.}

\item{stars}{If \code{TRUE}, add significance stars (e.g., \verb{p < .001***}). Can
also be a character vector, naming the columns that should include stars
for significant values. This is especially useful for Bayesian models,
where we might have multiple columns with significant values, e.g. \code{BF}
for the Bayes factor or \code{pd} for the probability of direction. In such
cases, use \code{stars = c("pd", "BF")} to add stars to both columns, or
\code{stars = "BF"} to only add stars to the Bayes factor and exclude the \code{pd}
column. Currently, following columns are recognized: \code{"BF"}, \code{"pd"} and \code{"p"}.}

\item{digits, ci_digits, p_digits, rope_digits, ic_digits}{Number of digits for
rounding or significant figures. May also be \code{"signif"} to return significant
figures or \code{"scientific"} to return scientific notation. Control the
number of digits by adding the value as suffix, e.g. \code{digits = "scientific4"}
to have scientific notation with 4 decimal places, or \code{digits = "signif5"}
for 5 significant figures (see also \code{\link[=signif]{signif()}}).}

\item{ci_width}{Minimum width of the returned string for confidence
intervals. If not \code{NULL} and width is larger than the string's length,
leading whitespaces are added to the string. If \code{width="auto"}, width
will be set to the length of the longest string.}

\item{ci_brackets}{Logical, if \code{TRUE} (default), CI-values are
encompassed in square brackets (else in parentheses).}

\item{zap_small}{Logical, if \code{TRUE}, small values are rounded after
\code{digits} decimal places. If \code{FALSE}, values with more decimal
places than \code{digits} are printed in scientific notation.}

\item{preserve_attributes}{Logical, if \code{TRUE}, preserves all attributes
from the input data frame.}

\item{exact}{Formatting for Bayes factor columns, in case the provided data
frame contains such a column (i.e. columns named \code{"BF"} or \code{"log_BF"}).
For \code{exact = TRUE}, very large or very small values are then either reported
with a scientific format (e.g., 4.24e5), else as truncated values (as "> 1000"
and "< 1/1000").}

\item{use_symbols}{Logical, if \code{TRUE}, column names that refer to particular
effectsizes (like Phi, Omega or Epsilon) include the related unicode-character
instead of the written name. This only works on Windows for R >= 4.2, and on
OS X or Linux for R >= 4.0. It is possible to define a global option for this
setting, see 'Note'.}

\item{verbose}{Toggle messages and warnings.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame. Note that \code{format_table()} converts all columns
into character vectors!
}
\description{
This functions takes a data frame (usually with model
parameters) as input and formats certain columns into a more readable
layout (like collapsing separate columns for lower and upper confidence
interval values). Furthermore, column names are formatted as well. Note
that \code{format_table()} converts all columns into character vectors!
}
\note{
\code{options(insight_use_symbols = TRUE)} overrides the \code{use_symbols} argument
and always displays symbols, if possible.
}
\examples{
\dontshow{if (require("rstanarm", warn.conflicts = FALSE) && require("parameters", warn.conflicts = FALSE) && packageVersion("parameters") > "0.22.2") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
format_table(head(iris), digits = 1)

m <- lm(Sepal.Length ~ Species * Sepal.Width, data = iris)
x <- parameters::model_parameters(m)
as.data.frame(format_table(x))
as.data.frame(format_table(x, p_digits = "scientific"))

\donttest{
model <- rstanarm::stan_glm(
  Sepal.Length ~ Species,
  data = iris,
  refresh = 0,
  seed = 123
)
x <- parameters::model_parameters(model, ci = c(0.69, 0.89, 0.95))
as.data.frame(format_table(x))
}
\dontshow{\}) # examplesIf}
}
\seealso{
Vignettes
\href{https://easystats.github.io/insight/articles/display.html}{Formatting, printing and exporting tables}
and \href{https://easystats.github.io/parameters/articles/model_parameters_formatting.html}{Formatting model parameters}.
}
