% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rename_r_to_R.R
\name{rename_r_to_R}
\alias{rename_r_to_R}
\title{Rename files' extensions in a folder from .r to .R}
\usage{
rename_r_to_R(subdir = ".", recursive = FALSE, message = TRUE,
  text_to_find = "\\\\.r$", new_extension = ".R", ...)
}
\arguments{
  \item{subdir}{(character) sub folder from the current
  working directoryl in which the files should be changed.
  Default is "".}

  \item{recursive}{(logical) FALSE. Should the function
  keep going into folders and check them as well?}

  \item{message}{(logical) should we output how many files
  were changed. (defualt is FALSE)}

  \item{text_to_find}{old file extension (should have $ at
  the end!)}

  \item{new_extension}{new file extension...}

  \item{...}{not used.}
}
\value{
(integer) the number of files changed
}
\description{
Rename files' extensions in a folder from .r to .R.
}
\details{
This came after a discussion with Hadley, JJ, and Martin
leading to the realization that since we are using the R
language (and not the r language), the standard is to use
.R files instead of .r

Be careful when using the recursive argument. And remember
that source("miao.r") and source("miao.R") Are NOT the
same...
}
\examples{
\dontrun{
rename_r_to_R() # changes only .r in the current wd
rename_r_to_R("R") # fixing the file ending inside a package directory
rename_r_to_R(recursive = TRUE) # Changes
rename_r_to_R(recursive = TRUE, message = FALSE) # Changes
# ALL of the .r files underneath the current
# working directory

# source: http://stackoverflow.com/questions/52950/how-to-make-git-ignore-changes-in-case
# First run the following in git bash:
# git config core.ignorecase false
rename_r_to_R(recursive = TRUE, text_to_find="\\\\.R$", new_extension = ".b")

# mmm, since it does not work nicely, you'd need to run the following:
# and commit between the two.
rename_r_to_R(recursive = TRUE, text_to_find="\\\\.r$", new_extension = ".b")
# commit!
rename_r_to_R(recursive = TRUE, text_to_find="\\\\.b$", new_extension = ".R")

}
}

