% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Surv2.R
\name{Surv2}
\alias{Surv2}
\title{Creating data frame}
\usage{
Surv2(v, u, w = NULL, event)
}
\arguments{
\item{v}{the last observation time prior to the failure; \eqn{0\le v \le u}}

\item{u}{the first observation time after the failure; \eqn{u \ge 0}}

\item{w}{a left truncation time or delayed entry time (default is \code{w = NULL})}

\item{event}{an indicator of cause of failure. If an observation is righ-censored, \code{event = 0}; otherwise, \code{event = 1} or \code{event = 2}, where \code{1} represents the first cause of failure, and \code{2} represents the second cause of failure. The current version of package only allows for two causes of failure.}
}
\value{
data frame
}
\description{
The function \code{Surv2} generates the survival object to be treated as the response from \code{ciregic}.
}
\details{
The function \code{Surv2} provides a response data frame which is used in the function \code{ciregic} and \code{ciregic_lt}. For interval-censored competing risks data, the function \code{Surv2} must use three parameters (\code{v, u, c}). For left-truncated and interval censored competing risks data, the function \code{Surv2} must use four parameters (\code{v, u, w, c}). If data are partially left-truncated, but all interval-censored, \code{w = 0} for only interval-censored competing risks data.
}
\examples{
attach(simdata)
Surv2(v = v, u = u, event = c)

}
\author{
Giorgos Bakoyannis, \email{gbakogia at iu dot edu}

Jun Park, \email{jp84 at iu dot edu}
}
\keyword{Surv2}
