% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionR_mover.R
\name{interactionR_mover}
\alias{interactionR_mover}
\title{Computes confidence intervals for interaction measures using the variance
recovery method by Zou (2018)}
\usage{
interactionR_mover(
  model,
  exposure_names = c(),
  ci.level = 0.95,
  em = T,
  recode = F
)
}
\arguments{
\item{model}{A fitted model object of class glm, clogit or coxph}

\item{exposure_names}{A character vector of two named binary exposure variables present in the fitted model: the default is an empty vector. If effect modification is being assessed, to get the right orientation of the table output, the first variable should be the putative effect modifier, the second, the main exposure. If it's interaction, the order doesn't matter.}

\item{ci.level}{Magnitude of the returned CI level. Default is 0.95}

\item{em}{TRUE (the default), for effect modification assessment. FALSE, for interaction.}

\item{recode}{If TRUE, recodes the exposures - if at least one of the exposures is protective - such that the stratum with the lowest risk becomes the new reference category when the two exposures are considered jointly.}
}
\value{
a list object of class 'interactionR' that includes a dataframe containing all effect estimates necessary for full reporting of effect modification or interaction analysis. @seealso \code{\link{interactionR_table}} for how to generate a publication-ready table with this object.
}
\description{
Computes confidence intervals for interaction measures using the variance
recovery method by Zou (2018)
}
\examples{
## Using Case-control data from Rothman and Keller (1972)
## evaluating the joint effect of alcohol and smoking
## on oral cancer risk is included in the package
## (cited in Hosmer and Lemeshow (1992) and Zou (2008))

## fit the interaction model
model.glm <- glm(oc ~ alc * smk,
  family = binomial(link = "logit"),
  data = OCdata
)

## Then pass the fitted model to the function
interactionR_mover(model.glm,
  exposure_names = c("alc", "smk"),
  ci.level = 0.95, em = FALSE, recode = FALSE
)
}
