% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dmcp}
\alias{dmcp}
\title{This function obtains the first derivative function of MCP (Minimax Concave Penalty)}
\usage{
dmcp(theta, lambda, gamma)
}
\arguments{
\item{theta}{a coefficient vector.}

\item{lambda}{the tuning parameter.}

\item{gamma}{the regularization parameter in MCP (Minimax Concave Penalty).
It balances between the unbiasedness and concavity of MCP.}
}
\value{
the first derivative of MCP function.
}
\description{
This function obtains the first derivative function of MCP (Minimax Concave Penalty)
}
\details{
Rigorously speaking, the regularization parametre \eqn{\gamma} needs to be obtained via a data-driven approach.
Published studies suggest experimenting with a few values, such as 1.8, 3, 4.5, 6, and 10, then fixing its value. In our numerical
study, we have examined this sequence and found that the results are not sensitive to the choice of value of \eqn{\gamma},
and set the value at 3. In practice, to be prudent, values other than 3 should also be investigated.
}
\examples{
theta=runif(20,-5,5)
lambda=1
gamma=3
dmcp(theta,lambda,gamma)
}
