% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{treatment}
\alias{treatment}
\title{Scheduling interim analyses in clinical trials}
\usage{
treatment(r, du, dr)
}
\arguments{
\item{r}{recruitment scenario calculated with function \code{recruitment}.}

\item{du}{duration of treatment phase in weeks.}

\item{dr}{drop-out rate during the treatment phase.}
}
\value{
\itemize{
\item \code{treatment} returns a list of vectors with the following components:
\item \code{patients} a vector with the (cumulative) number of patients who finished treatment
\item \code{weeksOfTrial} a vector with the corresponding trial week when patients have finished treatment
(with start of site openings as reference start)
}
}
\description{
Function \code{treatment} simulates the treatment phase base on a recruitment scenario simulated by function \code{recruitment}.
}
\details{
\code{treatment} simulates the treatment period based on a given recruitment scenario.
The function assumes a common fixed treatment length for all subjects (\code{du}).
The drop-out rate may be included via \code{dr}. If drop-out rates are available
only for different time periods, e.g. annual rates, function \code{\link{convertedRate}} can be used to convert
the rate to a drop-out rate for the respective treatment duration.
}
\examples{
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=treatment(r=x,du=26,dr=0.2)
z=treatment(r=x,du=52,dr=0.2)

x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=treatment(r=x,du=26,dr=convertedRate(0.3,52,26))
z=treatment(r=x,du=52,dr=0.3)
}
\seealso{
\code{\link{recruitment}} for simulating recruitment scenarios;
\code{\link{trialCourse}} for plots of recruitment and treatment scenarios;
\code{\link{convertedRate}} for converting drop-out rates for different time periods.
}

