% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{trialCourse}
\alias{trialCourse}
\title{Scheduling interim analyses in clinical trials}
\usage{
trialCourse(r, t1 = NULL, t2 = NULL, lp = "topright")
}
\arguments{
\item{r}{recruitment scenario calculated with function \code{recruitment}.}

\item{t1}{\emph{optional}. Treatment phase simulation from function \code{treatment}.}

\item{t2}{\emph{optional}. Treatment phase simulation from function \code{treatment}.}

\item{lp}{\emph{optional}. Position of legend, specified by keyword: "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", or "center".}
}
\description{
Function \code{trialCourse} plots the results of function \code{recruitment}
and function \code{treatment}.
}
\details{
Function \code{trialCourse} produces two plots to display results of enrollment
and treatment simulations.

The first plot displays the cumulative number of centers that have been opened
as well as the cumulative number of centers that have been closed, if applicable, per trial week.

The second plot displays the number of patients that have been screened and enrolled per trial week.
If at least one of the parameters \code{t1} and \code{t2} are not \code{NULL}, then
the number of patients finished treatment is also displayed.

It is possible to include two different treatment scenarios into one plot. This option may for example
be used to assess the timing for specific interim analyses, i.e. \code{t1} is used to assess when the
required number of patients for the interim analysis finished treatment while \code{t2} is used to assess
when the required number of patients for the final analysis finished treatment.
}
\examples{
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=treatment(r=x,du=26,dr=convertedRate(0.3,52,26))
z=treatment(r=x,du=52,dr=0.3)
trialCourse(r=x,t1=y,t2=z)
}
\seealso{
\code{\link{treatment}} for simulating the treatment duration for a given recruitment scenario;
\code{\link{recruitment}} for simulating recruitment scenarios.
}

