% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{trialWeek}
\alias{trialWeek}
\title{Scheduling interim analyses in clinical trials}
\usage{
trialWeek(t, p)
}
\arguments{
\item{t}{result of function \code{treatment}.}

\item{p}{number of patients for which the week shall be determined.}
}
\value{
The week in which the number of patients is reached.
}
\description{
Function \code{trialWeek} determines the week of the trial in which a certain number \code{p}
of patients finished treatment.
}
\details{
\code{trialWeek} is an auxilliary function required to assess the timing of interim analyses. It derives
the week of trial in which a certain number of patients finished treatment.

The output is required for function \code{cross}, which includes the information into an existing Patients diagram.
}
\examples{
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=treatment(r=x,du=26,dr=convertedRate(0.3,52,26))
z=treatment(r=x,du=52,dr=0.3)
trialCourse(r=x,t1=y,t2=z)
trialWeek(t=y,p=100)
}
\seealso{
\code{\link{cross}} for plotting results of function \code{trialWeek} into an existing Patients diagram.
}

