% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers_remove.R
\name{outliers_remove}
\alias{outliers_remove}
\title{Remove outliers}
\usage{
outliers_remove(data, trait, model)
}
\arguments{
\item{data}{Experimental design data frame with the factors and traits.}

\item{trait}{Name of the trait.}

\item{model}{The fixed or random effects in the model.}
}
\value{
list. 1. Table with date without outliers. 2. The outliers in the
  dataset.
}
\description{
Use the method M4 in Bernal Vasquez (2016). Bonferroni Holm test to judge
residuals standardized by the re scaled MAD (BH MADR).
}
\details{
Function to remove outliers in MET experiments
}
\examples{

library(inti)

rmout <- outliers_remove(
  data = potato
  , trait ="hi"
  , model = "0 + (1|bloque) + geno"
  )
  
rmout$outliers
  
}
\references{
Bernal Vasquez, Angela Maria, et al. “Outlier Detection Methods for
Generalized Lattices: A Case Study on the Transition from ANOVA to REML.”
Theoretical and Applied Genetics, vol. 129, no. 4, Apr. 2016.
}
