% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intsp-class.R
\docType{methods}
\name{plot,intsp,missing-method}
\alias{plot,intsp,missing-method}
\title{Create an interval plot for spatial points.}
\usage{
\S4method{plot}{intsp,missing}(x, locationsOnly = FALSE,
  legend.positions = c("left", "right"), cuts = c(5, 5),
  radSize = c(0.1, 3), pch = 16, alpha = 0.5, ...)
}
\arguments{
\item{x}{An object of class \code{intsp}.}

\item{locationsOnly}{If TRUE, simply plots geographic
locations.}

\item{legend.positions}{The positions of the center and radius legend
relative to the plotting window.}

\item{cuts}{The number of ranges of values to print in
the center and radius legend respectively.}

\item{radSize}{A vector of length 2 indicating the range
of point sizes to plot to visualize radii magnitudes.}

\item{pch}{The shape of the points
(see \code{\link{plot}}).}

\item{alpha}{The transparency of the points.}

\item{...}{Additional arguments to \code{\link[sp]{spplot}}.}
}
\description{
Calls \code{\link[sp]{spplot}} to plot the locations, centers, and
  radii of an interval-valued spatial data frame in a single figure.
}
