\name{cutHyperPlane}
\alias{cutHyperPlane}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Piece of Noisy Hyperplane }
\description{
  Generates \code{Ns} data points within the unit ball from a hyperplane 
  through the origin with noise added. \code{n} has to be at least \code{d},
  otherwise the function terminates with an error.
}
\usage{
cutHyperPlane(Ns, d, n, sd)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Ns}{ number of data points. }
  \item{d}{ dimension of hyperplane. }
  \item{n}{ dimension of noise. }
  \item{sd}{ standard deviation of noise. }
}
\details{
  The data set is generated the following way: First data points are sampled
  uniformly in a \code{d}-ball. After this, \code{(n-d)}-dimensional orthogonal noise with
  standard deviation \code{sd} in each direction is added. No noise is added in the
  directions parallel to the hyperplane since on an infinite plane adding 
  isotropic noise to a uniform distribution does not change the
  distribution. Finally all data points within distance 1 from the origin are
  considered as candidates for the data set that will be returned, out of the 
  candidates \code{Ns} data points are chosen randomly to be returned.
  If there are less than \code{Ns} candidates more candidates will be generated
  in the same way.
  
  The data generated by this function can be used to evaluate how much
  local dimension estimators are affected by noise.
}
\value{
A \code{Ns} x \code{n} matrix.
}

\author{
  Kerstin Johnsson, Lund University
}
\section{Warning}{ 
  If \code{sd} is high, \code{cutHyperPlane} will be slow and might not even
  be able to return a data set. If so, it will return \code{NULL}.
}

\seealso{
\code{\link{cutHyperSphere}}
}
\examples{
datap <- cutHyperPlane(100, 2, 3, 0.01)
par(mfrow = c(1, 2))
plot(datap[, 1], datap[, 2])
plot(datap[, 1], datap[, 3])

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ datagen }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
