##' Crystal weight data
##' 
##' The data give the growing time and final weight of crystals.
##' 
##' \itemize{
##'   \item \code{time} Time taken to grow (hours).
##'   \item \code{weight} Final weight of the crystal (grams).
##' }
##' @docType data
##' @keywords datasets
##' @format A data frame with 14 rows and 2 variables
##' @name crystal  
##' @references
##' Graybill, F. A., and Iyer, H. K. (1994)
##' \emph{Regression analysis: Concepts and Applications}. Duxbury Press.                       
NULL

##' Concentrations of arsenic in water samples
##' 
##' The data give the actual and measured concentrations of arsenic present in 
##' water samples.
##' 
##' \itemize{
##'   \item \code{actual} True amount of arsenic present
##'   \item \code{measured} Measured amount of arsenic present 
##' }
##' @docType data
##' @keywords datasets
##' @format A data frame with 32 rows and 2 variables
##' @name arsenic  
##' @references 
##' Graybill, F. A., and Iyer, H. K. (1994)
##' \emph{Regression analysis: Concepts and Applications}. Duxbury Press. 
NULL 
