% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_multipliers_create.R
\name{input_multipliers_create}
\alias{input_multipliers_create}
\title{Create input multipliers

The function creates the multipliers (direct + indirect effects).}
\usage{
input_multipliers_create(input_requirements, inverse, digits = NULL)
}
\arguments{
\item{input_requirements}{A matrix or vector created by 
\code{\link{input_indicator_create}}}

\item{inverse}{A Leontieff-inverse created by \code{\link{leontieff_inverse_create}}.}

\item{digits}{Rounding digits, defaults to \code{NULL}, in which case 
no rounding takes place. Rounding is important if you replicate examples from the literature,
rounding differences can add up to visible differences in matrix equations.}
}
\value{
A data frame with the vector of multipliers and the an 
auxiliary metadata column (for joining with other matrixes.)
}
\description{
Create input multipliers

The function creates the multipliers (direct + indirect effects).
}
\examples{
 
nl <- netherlands_2006

input_coeff_nl <- input_coefficient_matrix_create(
 data_table  = netherlands_2006, 
 households = FALSE) 

compensation_indicator <- input_indicator_create(netherlands_2006, 'compensation_employees')

I_nl <- leontieff_inverse_create(input_coeff_nl)

input_multipliers_create(input_requirements = compensation_indicator, 
                        inverse = I_nl)
}
\seealso{
Other multiplier functions: 
\code{\link{multiplier_create}()}
}
\concept{multiplier functions}
