% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_indicator_create.R
\name{input_indicator_create}
\alias{input_indicator_create}
\title{Create input indicator(s)}
\usage{
input_indicator_create(
  data_table,
  input_row = c("gva_bp", "net_tax_production"),
  digits = NULL,
  households = FALSE,
  indicator_names = NULL
)
}
\arguments{
\item{data_table}{A symmetric input-output table, a use table, 
a margins or tax table retrieved by the  \code{\link{iotable_get}}
function.}

\item{input_row}{The name of input(s) for which you want to create the 
indicator(s). Must be present in the \code{data_table}.}

\item{digits}{Rounding digits, if omitted, no rounding takes place.}

\item{households}{If the households column should be added, 
defaults to \code{FALSE}.}

\item{indicator_names}{The names of new indicators. Defaults to \code{NULL} when 
the names in the key column of \code{input_matrix} will be used to create the 
indicator names.}
}
\value{
A tibble (data frame) containing  \code{input_matrix} divided by the \code{output_vector}
with a key column for products or industries.
}
\description{
The function creates the input indicators from the inputs and
the outputs.
}
\examples{
 
input_indicator_create( data_table = iotable_get(), 
                        input_row = c("gva", "compensation_employees"),
                        digits = 4, 
                        indicator_names = c("GVA indicator", "Income indicator"))
}
\seealso{
Other indicator functions: 
\code{\link{coefficient_matrix_create}()},
\code{\link{direct_effects_create}()}
}
\concept{indicator functions}
