% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primary_input_get.R
\name{primary_input_get}
\alias{primary_input_get}
\title{Get primary inputs

This function will retrieve any primary input from the input-output 
table.}
\usage{
primary_input_get(data_table, primary_input = "compensation_employees")
}
\arguments{
\item{data_table}{A symmetric input-output table, a use table, or a 
supply table retrieved by the  \code{\link{iotable_get}} function.}

\item{primary_input}{The primary input to be returned from the table.}
}
\value{
A data frame with the vector of multipliers and the an 
auxiliary metadata column (for joining with other matrixes.)
}
\description{
Get primary inputs

This function will retrieve any primary input from the input-output 
table.
}
\examples{
comp_employees_de <- primary_input_get(
  data_table = iotable_get(), 
  primary_input = "compensation_employees") 
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
