% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iota_version_2.R
\name{get_patterns}
\alias{get_patterns}
\title{Get patterns}
\usage{
get_patterns(data, categorical_levels)
}
\arguments{
\item{data}{\code{Matrix} or \code{data.frame} containing the ratings. The
cases are in the rows and the raters are in the columns. Characters in the cells
are supported. At least two raters are necessary.}

\item{categorical_levels}{\code{Vector} containing all possible categories of
the content analysis.}
}
\value{
Function returns a \code{list} with the following components:
\item{n}{Integer representing the number of different patterns in the data.}
\item{shape}{\code{Matrix} containing all unique patterns in in the data.
Cells of the matrix are characters.}
\item{frq}{\code{Vector} containing the frequencies of the patterns.}
\item{count}{\code{Matrix} containing the relative frequencies of the
categories within each pattern. The number of rows equals the number of
patterns. The number of columns equals the number of categories.}
}
\description{
Auxiliary function written in \code{R} for providing the necessary information
about the patterns generated by raters. This function produces the
input for the EM-algorithm.
}
