% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfDist}
\alias{ipfDist}
\title{Distance function}
\usage{
ipfDist(train, test, method = "euclidean", subset = NULL, norm = 2,
  sd = 10, epsilon = 1e-30, alpha = 20, threshold = 20)
}
\arguments{
\item{train}{a vector, matrix or data frame containing a set
of training examples}

\item{test}{a vector, matrix or data frame containing a set
of test examples}

\item{method}{The method to be used to calculate the distance.
Implemented methods are: 'euclidean', 'manhattan', 'norm',
'LGD' and 'PLGD'}

\item{subset}{columns to use to compute the distance.}

\item{norm}{parameter for the 'norm' method}

\item{sd}{parameter for 'LGD' and 'PLGD' methods}

\item{epsilon}{parameter for 'LGD' and 'PLGD' methods}

\item{alpha}{parameter for 'PLGD' method}

\item{threshold}{parameter for 'PLGD' method}
}
\value{
This function returns a matrix with dimensions:
    nrow(test) x nrow(train), containing the distances from
    test observations to train observations
}
\description{
This function computes the distance from every observation
in the test set to every observation in the train test
}
\examples{
    ipfDist(ipftrain[,1:168], ipftest[,1:168])

    ipfDist(ipftrain, ipftest, subset = seq(1,168))

    ipfDist(ipftrain, ipftest, subset = c('LONGITUDE', 'LATITUDE'), method = 'manhattan')

}

