/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import java.awt.Rectangle;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.toolkit.ColorBridge;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.pograss.PoGraSS;

public class PPrimRectangle
extends PPrimBase {
    public Rectangle r = new Rectangle();
    public boolean drawBorder = true;
    public boolean allowColorBrushing = true;
    public boolean filled = true;
    private int[] pieces;
    private int MINHEIGHT = 1;
    private int MINWIDTH = 1;
    protected int orientation = 0;
    private boolean useCanvasOrientation = true;

    public PPrimRectangle() {
        this.useCanvasOrientation = true;
    }

    public PPrimRectangle(int n) {
        this.orientation = n;
        this.useCanvasOrientation = false;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean contains(int n, int n2) {
        return this.r == null ? false : this.r.contains(n, n2);
    }

    public boolean intersects(Rectangle rectangle) {
        return this.r == null ? false : this.r.intersects(rectangle);
    }

    public void paint(PoGraSS poGraSS, int n, SMarker sMarker) {
        if (this.r == null) {
            return;
        }
        if (this.dragging || !this.allowColorBrushing || !this.isBrushed(sMarker)) {
            this.pieces = null;
            Color color = this.dragging && this.fillColorDrag != null ? this.fillColorDrag : this.fillColor;
            Color color2 = this.drawBorder ? this.borderColor : null;
            this.drawRect(poGraSS, this.r, color, color2);
        } else {
            this.brushRect(poGraSS, sMarker, n, this.r, this.borderColor);
        }
    }

    public void paintSelected(PoGraSS poGraSS, int n, SMarker sMarker) {
        double d;
        if (this.r == null) {
            return;
        }
        if (!this.useCanvasOrientation) {
            n = this.orientation;
        }
        if ((d = this.getMarkedProportion(sMarker, -1)) > 0.0) {
            boolean bl = false;
            if (!this.allowColorBrushing || !this.isBrushed(sMarker)) {
                int n2 = this.r.x;
                int n3 = this.r.y;
                int n4 = this.r.width - 1;
                int n5 = this.r.height - 1;
                bl = true;
                switch (n) {
                    case 0: {
                        n5 = this.getPropSize(n5, d);
                        n3 += this.r.height - n5;
                        ++n2;
                        break;
                    }
                    case 1: {
                        n4 = this.getPropSize(n4, d);
                        ++n2;
                        ++n3;
                        break;
                    }
                    case 2: {
                        n5 = this.getPropSize(n5, d);
                        ++n2;
                        ++n3;
                        break;
                    }
                    case 3: {
                        n4 = this.getPropSize(n4, d);
                        n2 += this.r.width - n4;
                        ++n3;
                    }
                }
                this.drawRect(poGraSS, n2, n3, n4, n5, this.fillColorSel, null);
            } else {
                int n6 = this.r.x;
                int n7 = this.r.y;
                int n8 = this.r.width;
                int n9 = this.r.height;
                double d2 = n8;
                double d3 = n9;
                int n10 = -1;
                boolean bl2 = false;
                if (this.pieces != null) {
                    // empty if block
                }
            }
            if (bl) {
                poGraSS.setColor(this.borderColorSel);
                poGraSS.drawRect(this.r.x, this.r.y, this.r.width, this.r.height);
            }
        }
    }

    public String toString() {
        return "PPrimRectangle(" + (this.r == null ? "<null rectangle>" : "" + this.r.x + ":" + this.r.y + "," + this.r.width + ":" + this.r.height + "," + this.orientation) + ", cases=" + this.cases() + ", drawBorder=" + this.drawBorder + ")";
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.r.setBounds(n, n2, Math.max(n3, this.MINWIDTH), Math.max(n4, this.MINHEIGHT));
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.setBounds((int)d, (int)d2, (int)d3, (int)d4);
    }

    protected void brushRect(PoGraSS poGraSS, SMarker sMarker, int n, Rectangle rectangle, Color color) {
        int n2;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        double d = n5;
        double d2 = n6;
        int n7 = -1;
        int n8 = 0;
        boolean bl = false;
        double d3 = 0.0;
        double[] dArray = new double[sMarker.getMaxMark() + 2];
        for (n2 = -1; n2 <= sMarker.getMaxMark(); ++n2) {
            dArray[n2 + 1] = this.getMarkedProportion(sMarker, n2, true);
            d3 += dArray[n2 + 1];
        }
        if (d3 >= 1.0E-7) {
            n2 = (n & 1) == 0 ? n6 : n5;
            this.pieces = this.roundProportions(dArray, d3, n2);
            for (int i = -1; i <= sMarker.getMaxMark(); ++i) {
                if (!(dArray[i + 1] > 0.0)) continue;
                bl = true;
                if (n == 0) {
                    n6 = this.pieces[i + 1];
                    n4 = rectangle.y + rectangle.height - n8 - this.pieces[i + 1];
                } else if (n == 2) {
                    n6 = this.pieces[i + 1];
                    n4 = rectangle.y + n8;
                } else if (n == 1) {
                    n5 = this.pieces[i + 1];
                    n3 = rectangle.x + n8;
                } else if (n == 3) {
                    n5 = this.pieces[i + 1];
                    n3 = rectangle.x + rectangle.width - n8 - this.pieces[i + 1];
                }
                n8 += this.pieces[i + 1];
                poGraSS.setColor(i == -1 ? this.fillColorSel : ColorBridge.getMain().getColor(i));
                poGraSS.fillRect(n3, n4, n5, n6);
            }
        }
        if (bl) {
            this.drawRect(poGraSS, rectangle, null, color);
        }
    }

    protected void drawRect(PoGraSS poGraSS, Rectangle rectangle, Color color, Color color2) {
        this.drawRect(poGraSS, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, color2);
    }

    protected void drawRect(PoGraSS poGraSS, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (this.filled && color != null) {
            poGraSS.setColor(color);
            poGraSS.fillRect(n, n2, n3, n4);
        }
        if (color2 != null) {
            poGraSS.setColor(color2);
            poGraSS.drawRect(n, n2, n3, n4);
        }
    }

    protected boolean isBrushed(SMarker sMarker) {
        return sMarker.getSecCount() >= 1;
    }

    public void move(int n, int n2) {
        this.r.setLocation(n, n2);
    }

    public void moveX(int n) {
        this.move(n, this.r.y);
    }

    public void moveY(int n) {
        this.move(this.r.x, n);
    }

    public int getMINHEIGHT() {
        return this.MINHEIGHT;
    }

    public void setMINHEIGHT(int n) {
        this.MINHEIGHT = n;
        if (this.r != null && this.r.height < n) {
            this.r.height = n;
        }
    }

    public int getMINWIDTH() {
        return this.MINWIDTH;
    }

    public void setMINWIDTH(int n) {
        this.MINWIDTH = n;
        if (this.r != null && this.r.width < n) {
            this.r.width = n;
        }
    }
}

