\name{varset}
\alias{varset}

\title{Simulation Model}
\description{
Three sets of variables are calculated: explanatory, intermediate and response variables. 
}
\usage{
varset(N, sigma=0.1, theta=90, threshold=0, u=1:3)
}

\arguments{
  \item{N}{number of simulated observations.}
  \item{sigma}{standard deviation of the error term.}
  \item{theta}{angle between two u vectors.}
  \item{threshold}{cutpoint for classifying to 0 or 1.}
  \item{u}{starting values.}
}
\details{

For each observation values of two explanatory variables \eqn{x = (x_1, x_2)^{\top}} and of two responses \eqn{y = (y_1, y_2)^{\top}} are simulated, following the formula:
\deqn{
y = U*x+e = ({u_1^{\top} \atop u_2^{\top}})*x+e
}
where x is the evaluation of as standard normal random variable and e is generated by a normal variable with standard deviation \code{sigma}. U is a 2*2 Matrix, where 
\deqn{
u_1 = ({u_{1, 1} \atop u_{1, 2}}),
u_2 = ({u_{2, 1} \atop u_{2, 2}}),
||u_1|| = ||u_2|| = 1,
}
i.e. a matrix of two normalised vectors.
}
\value{
  A list containing the following arguments
  \item{explanatory}{N*2 matrix of 2 explanatory variables.}
  \item{intermediate}{N*2 matrix of 2 intermediate variables.}
  \item{response}{response vectors with values 0 or 1.}
}

\references{
David J. Hand, Hua Gui Li, Niall M. Adams (2001),
Supervised classification with structured class definitions.
\emph{Computational Statistics \& Data Analysis} \bold{36},
209--225.
}

\author{Andrea Peters <Peters.Andrea@imbe.imed.uni-erlangen.de>}

\examples{

theta90 <- varset(N = 1000, sigma = 0.1, theta = 90, threshold = 0)
theta0 <- varset(N = 1000, sigma = 0.1, theta = 0, threshold = 0)
par(mfrow = c(1, 2))
plot(theta0$intermediate)
plot(theta90$intermediate)

}

\keyword{misc}
