% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hlam.R
\name{Hlam}
\alias{Hlam}
\alias{Hlam}
\alias{Hlam.ipriorMod}
\alias{Hlam}
\alias{Hlam.ipriorKernel}
\title{Extract the scaled kernel matrix}
\usage{
Hlam(object, lambda = NULL)

\method{Hlam}{ipriorMod}(object, lambda = NULL)

\method{Hlam}{ipriorKernel}(object, lambda = NULL)
}
\arguments{
\item{object}{An object of class \code{ipriorMod} or \code{ipriorKernel}.}

\item{lambda}{(optional) Values of the scale parameters.}
}
\description{
Extract the scaled kernel matrix \eqn{\mathbf H_\lambda} of an
\code{ipriorMod} or \code{ipriorKernel} object.
}
\details{
The maximum likelihood values for \code{lambda} are used by default for
fitted I-prior models. For \code{ipriorKernel} objects, random values for
\code{lambda} are used.
}
\examples{
# Extracting from an ipriorMod object
mod.fit <- iprior(stack.loss ~ ., stackloss)
H.mat1 <- Hlam(mod.fit)
str(H.mat1)

# Extracting from an ipriorKernel object at a specified lambda value
mod <- mod.fit$ipriorKernel
H.mat2 <- Hlam(mod, mod.fit$lambda)

# They are both equal
all.equal(H.mat1, H.mat2)

}
