% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sister.R
\name{sister}
\alias{sister}
\title{Identification of Sister Nodes and Clades}
\usage{
sister(phy, node, type = "terminal", label = FALSE)
}
\arguments{
\item{phy}{An object of class \code{\link{phylo}}.}

\item{node}{A vector of mode \code{"numeric"} or \code{"character"} giving 
the number(s) or name(s) of the tiplabel(s); these must be monophyletic.}

\item{type}{A character string, may be \code{"terminal"}, \code{"internal"}, 
\code{"daughter"}, \code{"all"}, or any unambiguous abbreviation of these; 
\code{"daughter"} will return the MRCA of the sister clade of 
\code{"node"}.}

\item{label}{Logical, determining if tip number or tip labels will be 
returned.}
}
\value{
A vector of mode \code{"numeric"} or \code{"character"}, containing 
  either tip numbers or labels, respectively.
}
\description{
For any given internal node in a phylogeny, this function 
  returns the sister clade.
}
\examples{
# A phylogeny of bark beetles ...
data(ips.tree)
tcol <- rep("black", Ntip(ips.tree))
tcol[ips.tree$tip.label \%in\% c("Ips_typographus", "Ips_nitidus")] <- "blue"
tcol[ips.tree$tip.label \%in\% c("Ips_duplicatus")] <- "red"
plot(ips.tree, no.margin = TRUE, tip.color = tcol)
# What is the sister species of Ips typographus?
sister(ips.tree, "Ips_typographus", label = TRUE)
# Return the MRCA of the sister clade of Ips duplicatus
x <- sister(ips.tree, "Ips_duplicatus", "daughter")
nodelabels(node = x, pch = 21, bg = "red")
}
\seealso{
\code{\link{descendants}}, \code{\link{noi}}.
}
