% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ip_classify}
\alias{ip_classify}
\title{Identify whether an IP address is IPv4 or IPv6}
\usage{
ip_classify(ip_addresses)
}
\arguments{
\item{ip_addresses}{a vector of IPv4 or IPv6 IP addresses.}
}
\value{
a vector containing the class of each input IP address; either
"IPv4", "IPv6" or, for IP addresses that were not valid, NA.
}
\description{
Identify the form (IPv4 or IPv6) of a vector
of IP addresses. This can also be used to validate IPs.
}
\examples{

#IPv4
ip_classify("173.194.123.100")
#[1] "IPv4"

#IPv6
ip_classify("2607:f8b0:4006:80b::1004")
#[1] "IPv6"

#Invalid
ip_classify("East Coast Twitter is Best Twitter")
#[1] NA

}
\seealso{
\code{\link{is_valid}} et al for logical checks of IP addresses,
\code{\link{ip_to_hostname}} for resolving IP addresses to their
hostnames, and \code{\link{ip_to_numeric}} for converting (IPv4) IP addresses
to their numeric representation.
}
