% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terra_read.r
\name{read_terra_raster}
\alias{read_terra_raster}
\alias{read_terra_raster_list}
\title{Read data from an IPUMS Terra raster extract}
\usage{
read_terra_raster(data_file, data_layer = NULL, verbose = TRUE)

read_terra_raster_list(data_file, data_layer = NULL, verbose = TRUE)
}
\arguments{
\item{data_file}{Filepath to the data (either the .zip file directly downloaded
from the website, or the path to the unzipped .tiff file(s)).}

\item{data_layer}{For .zip extracts with multiple raster datasets, the name of the
 data to load. Accepts a character vector specifying the file name, or
\code{\link{dplyr_select_style}} conventions.}

\item{verbose}{Logical, indicating whether to print progress information
to console.}
}
\value{
For \code{read_terra_raster} A \code{\link[raster]{raster}} object, for
  \code{read_terra_raster_list} A list of raster objects.
}
\description{
Read a single raster datasets downloaded from the IPUMS Terra extract system using
\code{read_terra_raster}, or read multiple into a list using \code{read_terra_raster_list}.
}
\examples{
\dontrun{
data <- read_terra_raster("2552_bundle.zip", "LCDECIDOPZM2013.tiff")
data <- read_terra_raster_list("2552_bundle.zip", "ZM")
}
}
\seealso{
Other ipums_read: \code{\link{read_ipums_micro}},
  \code{\link{read_ipums_sf}}, \code{\link{read_nhgis}},
  \code{\link{read_terra_area}},
  \code{\link{read_terra_micro}}
}
