% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{set_ipums_var_attributes}
\alias{set_ipums_var_attributes}
\title{Add IPUMS variable attributes to a data.frame}
\usage{
set_ipums_var_attributes(data, var_info, var_attrs = c("val_labels",
  "var_label", "var_desc"))
}
\arguments{
\item{data}{A data.frame}

\item{var_info}{An \code{ipums_ddi} object or a data.frame with the
variable information (equivalent to getting ipums_var_info on a DDI).}

\item{var_attrs}{One or more of \code{val_labels}, \code{var_label} and
\code{var_desc} describing what kinds of attributes you want to add.
If NULL, will not add any attributes.}
}
\value{
A \code{tbl_df} data.frame with data and IPUMS attributes
}
\description{
Add variable attributes from an IPUMS DDI to the variables in a data.frame.
This function is usually called automatically for you inside of the read_*
functions (such as read_ipums_micro or read_nhgis), but they can
be useful other times as well. For example, if you store the data in
a database, you can store the data without attributes in the database
and add them on after loading a subset into a data.frame.
}
\details{
Attribute \code{val_labels} adds the haven::labelled class attributes and
the corresponding value labels for variables that have value labels.

Attribute \code{var_label} Adds a short summary of the variable's
contents that to the attribute "label". This label is viewable in the
RStudio Viewer.

Attribute \code{var_desc} Adds a longer summary of the variable's
contents to the attribute "var_desc" when available.
}
\examples{
  ddi_file <- ipums_example("cps_00006.xml")
  ddi <- read_ipums_ddi(ddi_file)
  cps <- read_ipums_micro(ddi, var_attrs = NULL) # Don't load with attributes

  ipums_var_desc(cps$YEAR) # Not available

  # But, we can add on attributes after loading
  cps_with_attr <- set_ipums_var_attributes(cps, ddi)
  ipums_var_desc(cps_with_attr$YEAR)

}
