% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-terra_read.R
\name{read_terra_area}
\alias{read_terra_area}
\alias{read_terra_area_sf}
\alias{read_terra_area_sp}
\title{Read data from an IPUMS Terra area extract}
\usage{
read_terra_area(
  data_file,
  data_layer = NULL,
  ddi_file = NULL,
  cb_file = NULL,
  verbose = TRUE,
  var_attrs = c("val_labels", "var_label", "var_desc")
)

read_terra_area_sf(
  data_file,
  shape_file = NULL,
  data_layer = NULL,
  shape_layer = data_layer,
  shape_encoding = "UTF-8",
  ddi_file = NULL,
  cb_file = NULL,
  verbose = TRUE,
  var_attrs = c("val_labels", "var_label", "var_desc")
)

read_terra_area_sp(
  data_file,
  shape_file = NULL,
  data_layer = NULL,
  shape_layer = data_layer,
  shape_encoding = "UTF-8",
  ddi_file = NULL,
  cb_file = NULL,
  verbose = TRUE,
  var_attrs = c("val_labels", "var_label", "var_desc")
)
}
\arguments{
\item{data_file}{Path to the data file, which can either be the .zip file directly
downloaded from the IPUMS Terra website, path to the unzipped folder, or to the
csv unzipped from the download.}

\item{data_layer}{For .zip extracts with multiple datasets, the name of the
data to load. Accepts a character vector specifying the file name, or
a \link[=selection_language]{tidyselect selection}. Data layer must uniquely
identify a dataset.}

\item{ddi_file}{(Optional) If the download is unzipped, path to the .xml file which
provides usage and citation information for extract.}

\item{cb_file}{(Optional) If the download is unzipped, path to the .txt file which
provides usage and citation information for extract.}

\item{verbose}{Logical, indicating whether to print progress information
to console.}

\item{var_attrs}{Variable attributes to add from the DDI, defaults to
adding all (val_labels, var_label and var_desc). See
\code{\link{set_ipums_var_attributes}} for more details.}

\item{shape_file}{(Optional) If the download is unzipped, path to the .zip,
folder path or .shp file representing the the shape file. If only the data
table is needed, can be set to FALSE to indicate not to load the shape
file.}

\item{shape_layer}{(Defaults to using the same value as data_layer) Specification
of which shape files to load using the same semantics as \code{data_layer}. Can
load multiple shape files, which will be combined.}

\item{shape_encoding}{The text encoding to use when reading the shape file. Typically
the defaults should read the data correctly, but for some extracts you may need
to set them manually, but if funny characters appear in your data, you may need
to. Defaults to "UTF-8" for IPUMS Terra.}
}
\value{
\code{read_terra_area} returns a \code{tbl_df} with the tabular data,
\code{read_terra_area_sf} returns a \code{sf} object with tabular data and shapes,
and \code{read_terra_area_sp} returns a \code{SpatialPolygonsDataFrame} with
data and shapes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Reads a area-level dataset downloaded from the IPUMS Terra extract system.

Support for IPUMS Terra has been discontinued. These functions will be
removed in a future release. For general handling of raster data in R, see the
\link[terra:terra-package]{terra} package.
}
\examples{
\dontrun{
data <- read_terra_area("2553_bundle.zip")
}
}
\keyword{internal}
