% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot_performance.R
\name{boxplot_performance}
\alias{boxplot_performance}
\title{Box Plot of the performance of a set of configurations}
\usage{
boxplot_performance(
  experiments,
  allElites = NULL,
  type = c("all", "ibest"),
  first_is_best = TRUE,
  rpd = TRUE,
  show_points = TRUE,
  best_color = "#08bfaa",
  x_lab = "Configurations",
  boxplot = FALSE,
  filename = NULL,
  interactive = base::interactive()
)
}
\arguments{
\item{experiments}{Experiment matrix obtained from irace training or testing data. Configurations
in columns and instances in rows. As in irace, column names (configurations ids)
should be characters.}

\item{allElites}{List or vector of configuration ids, (default NULL). These configurations
should be included in the plot. If the argument is not provided all configurations
in experiments are included. If allElites is a vector all configurations are
assumed without iteration unless argument \code{type="ibest"} is provided, in which case
each configuration is assumed to be from a different iteration. If \code{allElites}
is a list, each element of the  list is assumed as an iteration.}

\item{type}{String, (default "all") possible values are "all" or "ibest". "all"
shows all the selected configurations showing iterations if the information
is provided. "ibest" shows the elite configurations of each iteration, note
that the best configuration is always assumed to be first in the vector of
each iteration.}

\item{first_is_best}{Boolean (default TRUE) Enables the display in a different color the best configuration
identified as the first one in a vector. If FALSE, all configurations are shown
in the same color.}

\item{rpd}{(\code{logical(1)}) TRUE to plot performance as the relative
percentage deviation to best results per instance, FALSE to plot raw
performance.}

\item{show_points}{Logical, (default TRUE) TRUE to plot performance points together with the box plot.}

\item{best_color}{String, (default \code{"#08bfaa"}) color to display best configurations.}

\item{x_lab}{String, (default \code{"Configurations"}) label for the x axis.}

\item{boxplot}{By default, display a violin plot (\code{\link[ggplot2:geom_violin]{ggplot2::geom_violin()}}).
If \code{TRUE}, show a classical boxplot.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}

\item{interactive}{(\code{logical(1)}) TRUE if the report may use interactive features (using \code{\link[plotly:ggplotly]{plotly::ggplotly()}}, \code{\link[plotly:plot_ly]{plotly::plot_ly()}} and \code{\link[DT:dataTableOutput]{DT::renderDataTable()}}) or FALSE if such features must be disabled. Defaults to the value returned by \code{interactive()},}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} boxplot object
}
\description{
Creates a box plot that displays the performance of a set of configurations
which can be displayed by iteration.
}
\details{
The performance data is obtained from the experiment matrix provided in the
experiments argument. The configurations can be selected using the allElites
argument and this argument can be also used to define the iteration of each
elite configuration was evaluated.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
boxplot_performance(iraceResults$experiments, iraceResults$allElites)
\donttest{ 
boxplot_performance(iraceResults$testing$experiments, iraceResults$iterationElites)
}
}
\seealso{
\code{\link[=boxplot_test]{boxplot_test()}} \code{\link[=boxplot_training]{boxplot_training()}}
}
