% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_qa}
\alias{filter_qa}
\title{Filter with QA Band}
\usage{
filter_qa(DT, qa = "SummaryQA", good = c(0, 1))
}
\arguments{
\item{DT}{data.table of NDVI time series}

\item{qa}{QA column. default is 'SummaryQA'.}

\item{good}{values which correspond to quality pixels. default is 0 and 1.}
}
\value{
filtered data.table with appended 'filtered' column of "quality" NDVI.
}
\description{
Using MODIS QA band information, filter the NDVI time series.
}
\examples{
# Load data.table
library(data.table)

# Read example data
ndvi <- fread(system.file("extdata", "ndvi.csv", package = "irg"))

filter_qa(ndvi, qa = 'SummaryQA', good = c(0, 1))
}
\seealso{
Other filter: \code{\link{filter_ndvi}},
  \code{\link{filter_roll}}, \code{\link{filter_top}},
  \code{\link{filter_winter}}
}
\concept{filter}
