% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model_ndvi}
\alias{model_ndvi}
\title{Model NDVI time series}
\usage{
model_ndvi(DT, observed = TRUE)
}
\arguments{
\item{DT}{data.table of model parameters (output from model_params).}

\item{observed}{boolean indicating if a full year of fitted values should be returned (observed = FALSE) or if only observed values will be fit (observed = TRUE)}
}
\value{
Model parameter data.table appended with 'fitted' column of double logistic model of NDVI for a full year. Calculated at the daily scale with the following formula from Bischoff et al. (2012).

\deqn{fitted = \frac{1}{1 + \exp{\frac{xmidS - t}{scalS}}} - \frac{1}{1 + \exp{\frac{xmidA - t}{scalA}}}}

(See the "Getting started with irg vignette" for a better formatted formula.)
}
\description{
Fit double logistic model to NDVI time series given parameters estimated with model_params.
}
\examples{
# Load data.table
library(data.table)

# Read in example data
ndvi <- fread(system.file("extdata", "ndvi.csv", package = "irg"))

# Filter and scale NDVI time series
filter_ndvi(ndvi)
scale_doy(ndvi)
scale_ndvi(ndvi)

# Guess starting parameters for xmidS and xmidA
model_start(ndvi)

## Two options: fit to full year or observed data
# Option 1 - returns = 'models'

# Double logistic model parameters
#   given global starting parameters for scalS, scalA
#   and output of model_start for xmidS, xmidA
mods <- model_params(
  ndvi,
  returns = 'models',
  xmidS = 'xmidS_start',
  xmidA = 'xmidA_start',
  scalS = 0.05,
  scalA = 0.01
)

# Fit to the whole year (requires assignment)
fit <- model_ndvi(mods, observed = FALSE)

# Option 2 - returns = 'columns'
model_params(
  ndvi,
  returns = 'columns',
  xmidS = 'xmidS_start',
  xmidA = 'xmidA_start',
  scalS = 0.05,
  scalA = 0.01
)

# Fit double logistic curve to NDVI time series for the observed days
model_ndvi(ndvi, observed = TRUE)

}
\references{
\url{https://www.journals.uchicago.edu/doi/abs/10.1086/667590}
}
\seealso{
Other model: \code{\link{model_params}},
  \code{\link{model_start}}
}
\concept{model}
