% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irg.R
\name{irg}
\alias{irg}
\title{IRG}
\usage{
irg(DT)
}
\arguments{
\item{DT}{data.table of NDVI time series}
}
\value{
Extended data.table 'irg' column of instantaneous rate of green-up calculated for each day of the year, for each individual and year.
}
\description{
Wrapper function for one step IRG calculation. Only defaults.
}
\details{
data.table must have columns:

\itemize{
\item 'id' - individual identifier
\item 'yr' - year of observation
\item 'NDVI' - NDVI value
\item 'DayOfYear' - day of year/julian day of observation
\item 'SummaryQA' - summary quality value for each sample (provided by MODIS)
}
}
\examples{
# Load data.table
library(data.table)

# Read in example data
ndvi <- fread(system.file("extdata", "sampled-ndvi-MODIS-MOD13Q1.csv", package = "irg"))

# Calculate IRG for each day of the year and individual
out <- irg(ndvi)
}
\seealso{
Other irg: 
\code{\link{calc_irg}()}
}
\concept{irg}
