% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ar1_cross_cov}
\alias{ar1_cross_cov}
\title{Cross-covariance matrix of a stationary Gaussian AR(1) process.}
\usage{
ar1_cross_cov(times1, times2, rho, sigma)
}
\arguments{
\item{times1}{An vector of positive integers, preferably ordered.}

\item{times2}{An vector of positive integers, preferably ordered.}

\item{rho}{A real number strictly less than 1 in absolute value.}

\item{sigma}{A positive real number.}
}
\value{
A matrix with \code{length(times2)} rows and \code{length(times1)}
  columns.
}
\description{
Creates the cross-covariance matrix of an AR(1) process with parameters
\code{rho} and \code{sigma}, observed at (positive) integer times
\code{times1} and \code{times2}, which may be irregularly spaced. The
process is assumed to be in stationarity and to have Gaussian errors.
}
\examples{
times1 <- c(1, 3, 6)
times2 <- c(2, 4, 8:9)
rho <- 0.5
sigma <- 1
ar1_cross_cov(times1, times2, rho, sigma)
}
