% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{chol_tridiag_upper}
\alias{chol_tridiag_upper}
\title{Upper Cholesky decomposition of a tridiagonal matrix.}
\usage{
chol_tridiag_upper(Q)
}
\arguments{
\item{Q}{A square tridiagonal matrix.}
}
\value{
A sparse square matrix with the same size as the input matrix.
}
\description{
Creates the lower Cholesky decomposition of a tridiagonal matrix. The
decomposition will be a sparse lower triangular matrix with non-zero
elements only on the main diagonal and the diagonal below it.
}
\examples{
library(Matrix)
times <- c(1, 4:5, 7)
rho <- 0.5
sigma <- 1
Q <- ar1_prec_irregular(times, rho, sigma)
chol_tridiag_upper(Q)
}
