% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{plot.imp}
\alias{plot.imp}
\title{A plot method for the interaction model}
\usage{
\method{plot}{imp}(x, items = NULL, shade = 10, highlight = -Inf,
  add = FALSE, main = "Item-total regression", label = FALSE, ...)
}
\arguments{
\item{x}{An object produced by function \code{interactionModel}}

\item{items}{The items to plot (column numbers). If NULL, all items will be plotted}

\item{shade}{The part of the probability mass for the sum scores to shade out,
shown as percentage. Default is 10: shade the most extreme 10% of the distribution.
Ignored when \code{add=TRUE}.}

\item{highlight}{Cutpoint for the interaction parameter below which a regression
line will be highlighted in red. Default is -Inf (do not highlight).}

\item{add}{When \code{add=TRUE}, the graph is added to a plot, otherwise a new
plot is started. Default is FALSE.}

\item{main}{The main title of the plot, given that \code{add=FALSE}.}

\item{label}{When \code{label=TRUE}, individual curves will be labeled with the
item number.}

\item{...}{Any additional plotting parameters}
}
\description{
Plot the item-total regressions fit by the interaction (or Rasch) model
}
\examples{

plot(interactionModel(Scored), highlight=-.3)

}
\author{
Ivailo Partchev, using theory and C code by Gunter Maris
}
\seealso{
\code{\link{interactionModel}}
}
\keyword{models}

