% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setInfo.R
\name{getStudyFileNames}
\alias{getStudyFileNames}
\title{Retrieve the Study Identifier(s) and Study File Name(s) from an ISA object.}
\usage{
getStudyFileNames(isaObject)
}
\arguments{
\item{isaObject}{An object of the \code{\link{ISA-class}}.}
}
\value{
A named character vector containing the Study File Name(s) and the
name(s) representing the Study Identifier(s).
}
\description{
Retrieve from an object of the \code{\link{ISA-class}} the Study
Identifier(s) and Study File Name(s) as contained in the Investigation.
To directly access the Study Identifier(s) use the names() function, e.g.
\code{names(getStudyFileNames(isaObject))}.
}
\examples{
## Read example Atwell data set.
isaObject1 <- readISATab(path = file.path(system.file("extdata/Atwell",
                                          package = "isatabr")))

## Extract study identifiers and file names.
getStudyFileNames(isaObject1)

}
