% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isd_parser.R
\name{isd_parse}
\alias{isd_parse}
\title{Parse NOAA ISD/ISH data files}
\usage{
isd_parse(path, additional = TRUE, parallel = FALSE,
  cores = getOption("cl.cores", 2), progress = FALSE)
}
\arguments{
\item{path}{(character) file path. required}

\item{additional}{(logical) include additional and remarks data sections
in output. Default: \code{TRUE}}

\item{parallel}{(logical). do processing in parallel. Default: \code{FALSE}}

\item{cores}{(integer) number of cores to use: Default: 2. We look in
your option "cl.cores", but use default value if not found.}

\item{progress}{(logical) print progress - ignored if \code{parallel=TRUE}.
The default is \code{FALSE} because printing progress adds a small bit of
time, so if processing time is important, then keep as \code{FALSE}}
}
\value{
A tibble (data.frame)
}
\description{
Parse NOAA ISD/ISH data files
}
\examples{
path <- system.file('extdata/104270-99999-1928.gz', package = "isdparser")

(res <- isd_parse(path))

# with progress
(res2 <- isd_parse(path, progress = TRUE))

# only control + mandatory sections
(res <- isd_parse(path, additional = FALSE))

\dontrun{
# in parallel
(out <- isd_parse(path, parallel = TRUE))
}
}
\references{
ftp://ftp.ncdc.noaa.gov/pub/data/noaa
}
\seealso{
\code{\link{isd_parse_line}}
}
