% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d13C.to.CiCa.R
\name{d13C.to.CiCa}
\alias{d13C.to.CiCa}
\title{d13C.to.CiCa}
\usage{
d13C.to.CiCa(d13C, year, elevation, temp, frac = 0)
}
\arguments{
\item{d13C}{Measured plant tissue carbon isotope signature, per mille (‰)}

\item{year}{Year to which the sample corresponds}

\item{elevation}{Elevation (m.a.s.l.) of the sample, necessary to account for photorespiration processes}

\item{temp}{Leaf temperature (°C)}

\item{frac}{Post-photosynthetic fractionation factor, defaults to 0 assuming leaf material, user should supply reasonable value if from wood (generally -1.9 - -2.1)}
}
\value{
The ratio of leaf intercellular to atmospheric CO2 (Ci/Ca), unitless
}
\description{
Calculates the ratio of the concentration of leaf intercellular to atmospheric CO2, unitless.
}
\examples{
d13C.to.CiCa(-27, 2015, 900, 24)




}
\references{
Badeck, F.-W., Tcherkez, G., Nogués, S., Piel, C. & Ghashghaie, J. (2005). Post-photosynthetic fractionation of stable carbon isotopes between plant organs—a widespread phenomenon. Rapid Commun. Mass Spectrom., 19, 1381–1391.

Belmecheri, S. & Lavergne, A. (2020). Compiled records of atmospheric CO2 concentrations and stable carbon isotopes to reconstruct climate and derive plant ecophysiological indices from tree rings. Dendrochronologia, 63, 125748.

Bernacchi, C.J., Singsaas, E.L., Pimentel, C., Portis Jr, A.R. & Long, S.P. (2001). Improved temperature response functions for models of Rubisco-limited photosynthesis. Plant, Cell Environ., 24, 253–259.

Craig, H. (1953). The geochemistry of the stable carbon isotopes. Geochim. Cosmochim. Acta, 3, 53–92.

Davies, J.A. & Allen, C.D. (1973). Equilibrium, Potential and Actual Evaporation from Cropped Surfaces in Southern Ontario. J. Appl. Meteorol., 12, 649–657.

Farquhar, G., O’Leary, M. & Berry, J. (1982). On the relationship between carbon isotope discrimination and the intercellular carbon dioxide concentration in leaves. Aust. J. Plant Physiol., 9, 121–137.

Frank, D.C., Poulter, B., Saurer, M., Esper, J., Huntingford, C., Helle, G., et al. (2015). Water-use efficiency and transpiration across European forests during the Anthropocene. Nat. Clim. Chang., 5, 579–583.

Tsilingiris, P.T. (2008). Thermophysical and transport properties of humid air at temperature range between 0 and 100°C. Energy Convers. Manag., 49, 1098–1110.

Ubierna, N. & Farquhar, G.D. (2014). Advances in measurements and models of photosynthetic carbon isotope discrimination in C3 plants. Plant. Cell Environ., 37, 1494–1498.
}
