% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_points.R
\docType{methods}
\name{ternary_points}
\alias{ternary_points}
\alias{ternary_points-method}
\alias{ternary_points,numeric,numeric,numeric-method}
\alias{ternary_points,ANY,missing,missing-method}
\title{Add Points to a Ternary Plot}
\usage{
ternary_points(x, y, z, ...)

\S4method{ternary_points}{numeric,numeric,numeric}(x, y, z, type = "p", ...)

\S4method{ternary_points}{ANY,missing,missing}(x, type = "p", ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further graphical parameters (see \code{\link[graphics:par]{graphics::par()}}) may also be
supplied as arguments, particularly, plotting character, \code{pch}, character
expansion, \code{cex} and color, \code{col}.}

\item{type}{A \code{\link{character}} string indicating the type of plotting; actually
any of the types as in \code{\link[graphics:plot.default]{graphics::plot.default()}}.}
}
\value{
\code{ternary_points()} is called it for its side-effects.
}
\description{
Add Points to a Ternary Plot
}
\examples{
## Add points
## Data from Aitchison 1986
ternary_plot(NULL, panel.first = ternary_grid())
ternary_points(lava, col = "red", pch = 16)
}
\seealso{
\code{\link[graphics:points]{graphics::points()}}

Other geometries: 
\code{\link{ternary_arrows}()},
\code{\link{ternary_crosshairs}()},
\code{\link{ternary_lines}()},
\code{\link{ternary_polygon}()},
\code{\link{ternary_segments}()},
\code{\link{ternary_text}()}
}
\author{
N. Frerebeau
}
\concept{geometries}
