% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{isotree.set.reference.points}
\alias{isotree.set.reference.points}
\title{Set Reference Points to Calculate Distances or Kernels With}
\usage{
isotree.set.reference.points(model, data, with_distances = FALSE)
}
\arguments{
\item{model}{An Isolation Forest model (as returned by function \link{isolation.forest})
for which reference points for distance and/or kernel calculations will be set.

\bold{The object will be modified in-place}.}

\item{data}{Observations to set as reference points for future distance and/or isolation kernel calculations.
Same format as for \link{predict.isolation_forest}.}

\item{with_distances}{Whether to pre-calculate node distances (this is required to calculate distance
from arbitrary points to the reference points).

Note that reference points for distances can only be set when using `assume_full_distr=FALSE`
(which is the default).}
}
\value{
The same `model` object (as invisible), but now with added reference points that
can be used for new distance and/or kernel calculations with respect to other arbitrary points.
}
\description{
Sets some points as pre-defined landmarks with respect to which distances and/or
isolation kernel values will be calculated for arbitrary new points in calls to
`predict` with types `"dist"`, `"avg_sep"`, `"kernel"`. If any points have already been set
as references in the model object, they will be overwritten with the new points passed here.

Be aware that adding reference points requires building a tree indexer.
}
\details{
Note that points are added in terms of their terminal node indices, but the raw data about
them is not kept - thus, calling \link{isotree.add.tree} later on a model with reference points
requires passing those reference points again to add their node indices to the new tree.
}
\seealso{
\link{isotree.build.indexer}
}
