% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{isotree.is.same}
\alias{isotree.is.same}
\title{Check if two Isolation Forest Models Share the Same C++ Object}
\usage{
isotree.is.same(obj1, obj2)
}
\arguments{
\item{obj1}{First model to compare (against `obj2`).}

\item{obj2}{Second model to compare (against `obj1`).}
}
\value{
A logical (boolean) value which will be `TRUE` when both models
have a reference to the same C++ object, or `FALSE` otherwise.
}
\description{
Checks if two isolation forest models, as produced by functions
like \link{isolation.forest}, have a reference to the same underlying C++ object.

When this is the case, functions that produce in-place modifications, such as
\link{isotree.build.indexer}, will produce changes in all of the R variables that
share the same C++ object.

Two R variables will have the same C++ object when assigning one variable to another,
but will have different C++ objects when these R objects are serialized and
deserialized or when calling \link{isotree.deep.copy}.
}
\examples{
library(isotree)
data(mtcars)
model <- isolation.forest(mtcars, ntrees = 10, nthreads = 1, ndim = 1)

model_shallow_copy <- model
isotree.is.same(model, model_shallow_copy)

model_deep_copy <- isotree.deep.copy(model)
isotree.is.same(model, model_deep_copy)

isotree.add.tree(model_shallow_copy, mtcars)
length(isotree.get.num.nodes(model_shallow_copy)$total)
length(isotree.get.num.nodes(model)$total)
length(isotree.get.num.nodes(model_deep_copy)$total)
}
\seealso{
\link{isotree.deep.copy}
}
