% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_i_stat.R
\name{search_i_stat}
\alias{search_i_stat}
\title{Search data sets by keywords (source: I.Stat)}
\usage{
search_i_stat(keywords,
              lang = "ita")
}
\arguments{
\item{keywords}{keyword(s) to search data sets}

\item{lang}{language parameter for labels ("ita" for Italian, "eng" for English)}
}
\value{
It returns a list of data sets containing the keyword(s) with their id and name.
}
\description{
Search I.Stat data sets by keywords. To download data sets, use "get_i_stat" function and insert data set id.
}
\note{
Searching may take some time. Future versions will speed up the process.
}
\examples{
\donttest{search_i_stat(c( "incidenti", "stradali"))}
\donttest{search_i_stat("population", lang="eng")}
}
