% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{agi}
\alias{agi}
\title{An\enc{á}{a}lisis gr\enc{á}{a}fico de \enc{í}{i}tems.}
\usage{
agi(respuestas, clave, nGrupos = 4, nOpciones = 4)
}
\arguments{
\item{respuestas}{Una matriz con las alternativas seleccionada por los estudiantes
a cada \enc{í}{i}tem de la prueba.}

\item{clave}{Una matriz con la alternativa correcta para cada \enc{í}{i}tem.}

\item{nGrupos}{N\enc{ú}{u}mero de grupos en los que se categorizar\enc{á}{a}n los puntajes.}

\item{nOpciones}{N\enc{ú}{u}mero de alternativas posibles para cada \enc{í}{i}tem.}
}
\value{
Una matriz con la correlaci\enc{ó}{o}n biserial puntual para cada \enc{í}{i}tem y para cada
alternativa.
}
\description{
El an\enc{á}{a}lisis gr\enc{á}{a}fico de \enc{í}{i}tems permite visualizar
las alternativas que eligen los estudiantes seg\enc{ú}{u}n su desempe\enc{ñ}{n}o
general en la prueba. A partir de una matriz de respuestas y de un vector de puntajes
se puede agrupar a los estudiantes seg\enc{ú}{u}n su puntaje y calcular la
proporci\enc{ó}{o}n en que cada grupo seleccion\enc{ó}{o} cada alternativa.
Esta funci\enc{ó}{o}n devuelve un gr\enc{á}{a}fico por cada \enc{í}{i}tem que relaciona
la frecuencia de selecci\enc{ó}{o}n de cada alternatica con los grupos de puntajes.
Requiere los paquetes \pkg{\link{ggplot2}} y \pkg{\link{reshape}}.
}
\examples{
data(datos)
data(clave)
respuestas <- subset(datos, select=-id)
plots <- agi(respuestas, clave, nGrupos=ncol(respuestas)/2)
plots[[1]][[1]]
plots[[2]][[1]]

}
\references{
Ensenada, B. (2010). Manual para el an\enc{á}{a}lisis gr\enc{á}{a}fico
de \enc{í}{i}tems. Baja California. Recuperado de \url{http://www.educacionbc.edu.mx/departamentos/evaluacion/eacademicos/archivos/jornadasBC/MANUAL_PAGI.pdf}
}
\seealso{
\code{\link{corregirItems}}, \code{\link{analizarDistractores}},
\code{\link{frecuenciaDistractores}}, \code{\link{analizarItems}}, \code{\link{pBis}} y
\code{\link{calcularPuntajes}}
}
